VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Registry"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'------------------------------------------------------------------
' Name : Registry
'
' Purpose : Purpose an interface to access the registry
'
' Methods :
'    1) BackOneSubKey       Up to the parent key
'    2) CloseCurrentKey     Close the current key
'    3) CreateSubKey        Create a new sub key
'    4) CreateValue         Create a new value
'    5) DeleteSubKey        Delete a sub key
'    6) DeleteValue         Delete a value
'    7) GetAllSubKeys       Get all the sub keys
'    8) GetAllValues        Get all the values
'    9) GetValue            Get one value
'   10) OpenSubKey          Open a sub key from the root or from
'                           the current key
'   11) Property RootKey    Read/Change the current Root Key
'   12) Property Key        Read/Change the current Key
'
' Warning :
'       This class does'nt read/create all value type :
'           No  - REG_NONE = 0
'           Yes - REG_SZ = 1
'           Yes - REG_EXPAND_SZ = 2
'           Yes - REG_BINARY = 3
'           Yes - REG_DWORD = 4
'           Yes - REG_DWORD_LITTLE_ENDIAN = 4
'           No  - REG_DWORD_BIG_ENDIAN = 5
'           No  - REG_LINK = 6
'           Yes - REG_MULTI_SZ = 7
'           No  - REG_RESOURCE_LIST = 8
'           No  - REG_FULL_RESOURCE_DESCRIPTOR = 9
'           No  - REG_RESOURCE_REQUIREMENTS_LIST = 10
'
' review : 15/Feb/2000 by Alexandre Delavanne
'------------------------------------------------------------------

Private Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As Long) As Long
Private Declare Function RegEnumKey Lib "advapi32.dll" Alias "RegEnumKeyA" (ByVal hKey As Long, ByVal dwIndex As Long, ByVal lpName As String, ByVal cbName As Long) As Long
Private Declare Function RegEnumValue Lib "advapi32.dll" Alias "RegEnumValueA" (ByVal hKey As Long, ByVal dwIndex As Long, ByVal lpName As String, cbName As Long, ByVal lpReserved As Long, lpType As Long, ByVal lpData As String, lpcbData As Long) As Long
Private Declare Function RegQueryValueEx Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Long) As Long
Private Declare Function RegDeleteValue Lib "advapi32.dll" Alias "RegDeleteValueA" (ByVal hKey As Long, ByVal lpValueName As String) As Long
Private Declare Function RegDeleteKey Lib "advapi32.dll" Alias "RegDeleteKeyA" (ByVal hKey As Long, ByVal lpKeyName As String) As Long
Private Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long
Private Declare Function ExpandEnvironmentStrings Lib "advapi32.dll" (lpSrc As String, lpDst As String, ByVal nSize As Long) As Long
Private Declare Function RegCreateKeyEx Lib "advapi32" Alias "RegCreateKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal Reserved As Long, ByVal lpClass As String, ByVal dwOptions As Long, ByVal samDesired As Long, lpSecurityAttributes As SECURITY_ATTRIBUTES, phkResult As Long, lpdwDisposition As Long) As Long
Private Declare Function RegSetValueEx Lib "advapi32" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, ByVal lpData As String, ByVal cbData As Long) As Long

Private Type SECURITY_ATTRIBUTES
    nLength As Long
    lpSecurityDescriptor As Variant
    bInheritHandle As Long
End Type

'Define all the existing subkeys
Public Enum HKeys
    HKEY_CLASSES_ROOT = &H80000000
    HKEY_CURRENT_USER = &H80000001
    HKEY_LOCAL_MACHINE = &H80000002
    HKEY_USERS = &H80000003
    HKEY_PERFORMANCE_DATA = &H80000004
    HKEY_CURRENT_CONFIG = &H80000005
    HKEY_DYN_DATA = &H80000006
End Enum

'Define all the possible data type
Public Enum lDataType
    REG_NONE = 0
    REG_SZ = 1
    REG_EXPAND_SZ = 2
    REG_BINARY = 3
    REG_DWORD = 4
    REG_DWORD_LITTLE_ENDIAN = 4
    REG_DWORD_BIG_ENDIAN = 5
    REG_LINK = 6
    REG_MULTI_SZ = 7
    REG_RESOURCE_LIST = 8
    REG_FULL_RESOURCE_DESCRIPTOR = 9
    REG_RESOURCE_REQUIREMENTS_LIST = 10
End Enum

Private Const STANDARD_RIGHTS_ALL = &H1F0000
Private Const KEY_QUERY_VALUE = &H1
Private Const KEY_SET_VALUE = &H2
Private Const KEY_CREATE_SUB_KEY = &H4
Private Const KEY_ENUMERATE_SUB_KEYS = &H8
Private Const KEY_NOTIFY = &H10
Private Const KEY_CREATE_LINK = &H20
Private Const SYNCHRONIZE = &H100000
Private Const KEY_READ = &H20009
Private Const KEY_WRITE = &H20006
Private Const KEY_READ_WRITE = (KEY_READ Or KEY_WRITE)
Private Const KEY_ALL_ACCESS = ((STANDARD_RIGHTS_ALL Or KEY_QUERY_VALUE Or KEY_SET_VALUE Or KEY_CREATE_SUB_KEY Or KEY_ENUMERATE_SUB_KEYS Or KEY_NOTIFY Or KEY_CREATE_LINK) And (Not SYNCHRONIZE))
Private Const REG_OPTION_NON_VOLATILE = 0&
Private Const REG_OPTION_VOLATILE = &H1

Dim ml_RootKey As HKeys
Dim ms_SubKey As String
Dim ml_CurrentKeyHandle As Long

Public Property Get RootKey() As HKeys
'------------------------------------------------------------------
' Name : RootKey (Get)
'
' Purpose : Return the current Root Key
'
' Parameters : None
'
' Return : None
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    RootKey = ml_RootKey
End Property

Public Property Let RootKey(lo_RootKey As HKeys)
'------------------------------------------------------------------
' Name : RootKey (Let)
'
' Purpose : Change the current root key
'
' Parameters : None
'
' Return : None
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    If ml_CurrentKeyHandle <> 0 Then CloseCurrentKey
    ml_RootKey = lo_RootKey
End Property

Public Property Get Key() As String
'------------------------------------------------------------------
' Name : Key (Get)
'
' Purpose : Return the current key
'
' Parameters : None
'
' Return : None
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    Key = ms_SubKey
End Property

Public Property Let Key(ls_SubKey As String)
'------------------------------------------------------------------
' Name : Key (Let)
'
' Purpose : Change the current key from the root !
'
' Parameters : None
'
' Return : None
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    OpenSubKey ls_SubKey, True
End Property

Public Function CreateSubKey(ByVal ls_SubKey As String, Optional lb_FromRoot As Boolean = False) As Boolean
'------------------------------------------------------------------
' Name : CreateSubKey
'
' Purpose : Create a new sub key from the root or from the current
'           key. The new sub key is automatically opened
'
' Parameters :
'       ls_SubKey       The new subkey to create
'       lb_FromRoot     True: Create the sub key from the root (default)
'                       False: Create the sub key from the current
'                              key
'
' Return : True if the sub key was correctly created otherwise false
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim ll_Result As Long
Dim ll_NewKeyHandle As Long
Dim lpSecurityAttributes As SECURITY_ATTRIBUTES
Dim lpdwDisposition As Long
Dim ll_Handle As Long

    CreateSubKey = False
    
    On Error GoTo CreateSubKey_Err
    
    If lb_FromRoot = False Then
        If ml_CurrentKeyHandle = 0 Then Exit Function
        ll_Handle = ml_CurrentKeyHandle
    Else
        If ml_CurrentKeyHandle <> 0 Then CloseCurrentKey
        If ml_RootKey = 0 Then Exit Function
        ll_Handle = ml_RootKey
    End If
    
    ll_Result = RegCreateKeyEx(ll_Handle, ls_SubKey, 0&, "", REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, lpSecurityAttributes, ll_NewKeyHandle, lpdwDisposition)

    If ll_Result <> 0 Then Exit Function

    ml_CurrentKeyHandle = ll_NewKeyHandle
    
    ms_SubKey = AddSubKeyString(ms_SubKey, ls_SubKey)
    
    CreateSubKey = True

    Exit Function
    
CreateSubKey_Err:

End Function

Public Function DeleteSubKey(ByVal ls_SubKey As String, Optional lb_FromRoot As Boolean = False) As Boolean
'------------------------------------------------------------------
' Name : DeleteSubKey
'
' Purpose : Delete the sub key from the root or from the current
'           key. In the first case, the current key is closed.
'           In the second case, the current key remains opened.
'
' Parameters :
'       ls_SubKey       The Sub key to delete
'       lb_FromRoot     True: Delete the sub key from the root (default)
'                       False: Delete the sub key from the current
'                              key
'
' Return : True if the sub key was correctly deleted otherwise false
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim ll_Result As Long
Dim ll_Handle As Long

    DeleteSubKey = False
    
    On Error GoTo DeleteSubKey_Err
    
    If lb_FromRoot = False Then
        If ml_CurrentKeyHandle = 0 Then Exit Function
        ll_Handle = ml_CurrentKeyHandle
    Else
        If ml_CurrentKeyHandle <> 0 Then CloseCurrentKey
        If ml_RootKey = 0 Then Exit Function
        ll_Handle = ml_RootKey
    End If
    
    ll_Result = RegDeleteKey(ll_Handle, ls_SubKey)

    If ll_Result <> 0 Then Exit Function

    DeleteSubKey = True

    Exit Function

DeleteSubKey_Err:

End Function

'This method open a key in the current root Key
Public Function OpenSubKey(ByVal ls_SubKey As String, Optional lb_FromRoot As Boolean = False) As Boolean
'------------------------------------------------------------------
' Name : OpenSubKey
'
' Purpose : Open the sub key from the root or from the current key.
'
' Parameters :
'       ls_SubKey       The Sub key to open
'       lb_FromRoot     True: Open the sub key from the root (default)
'                       False: Open the sub key from the current
'                              key
'
' Return : True if the sub key was correctly opened otherwise false
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim ll_Result As Long
Dim ll_NewKeyHandle As Long
Dim ll_Handle As Long

    OpenSubKey = False

    On Error GoTo OpenSubKey_Err

    If Right(ls_SubKey, 1) = "\" Then ls_SubKey = Mid(ls_SubKey, 1, Len(ls_SubKey) - 1)

    If lb_FromRoot = False Then
        If ml_CurrentKeyHandle = 0 Then Exit Function
        ll_Handle = ml_CurrentKeyHandle
    Else
        If ml_CurrentKeyHandle <> 0 Then CloseCurrentKey
        If ml_RootKey = 0 Then Exit Function
        ll_Handle = ml_RootKey
    End If
    
    ll_Result = RegOpenKeyEx(ll_Handle, ls_SubKey, 0&, KEY_READ_WRITE, ll_NewKeyHandle)

    If ll_Result <> 0 Then
        ll_Result = RegOpenKeyEx(ll_Handle, ls_SubKey, 0&, KEY_READ, ll_NewKeyHandle)
        If ll_Result <> 0 Then
            Exit Function
        End If
    End If
    
    ms_SubKey = AddSubKeyString(ms_SubKey, ls_SubKey)
    ml_CurrentKeyHandle = ll_NewKeyHandle
    
    OpenSubKey = True
    
    Exit Function
    
OpenSubKey_Err:

End Function

Public Function CloseCurrentKey() As Boolean
'------------------------------------------------------------------
' Name : CloseCurrentKey
'
' Purpose : Close the current Key
'
' Parameters : None
'
' Return : True if the key was correctly closed otherwise false
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim ll_Result As Long
    
    On Error GoTo CloseCurrentKey_Err

    CloseCurrentKey = False
    
    If ml_CurrentKeyHandle = 0 Then Exit Function

    ll_Result = RegCloseKey(ml_CurrentKeyHandle)
    If ll_Result <> 0 Then Exit Function

    CloseCurrentKey = True
    ms_SubKey = ""
    ml_CurrentKeyHandle = 0
        
CloseCurrentKey_Err:

End Function

Public Function CreateValue(ByVal ls_ValueName As String, ByVal lo_Value As Variant, lo_ValueType As lDataType, Optional lo_MultiSZ_AdditionnalStrings As Variant) As Boolean
'------------------------------------------------------------------
' Name : CreateValue
'
' Purpose : Create a new value in the current key
'
' Parameters :
'       ls_ValueName        Name of the new value
'       lo_Value            The value to add
'       lo_ValueType        Indicates the type of the value
'       lo_MultiSZ_AdditionnalStrings   Array of additionnal strings
'                           This parameter is optional and is only
'                           used with REG_MULTI_SZ type
'
' Return : True if the value was correctly created otherwise false
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim ls_value As String
Dim ll_Size As Long
Dim ll_Result As Long
Dim ls_AdditionnalString As Variant

    Dim lpData As String 'The pointer to the value written to the Registry key's value
    Dim cbData As Long 'The size of the data written to the Registry key's value, including termination characters If applicable
    Dim lReturn As Long 'The Error value returned by the Registry Function
    Dim Str As Variant
    
    CreateValue = False
    
    On Error GoTo CreateValue_Err
    
    If ml_CurrentKeyHandle = 0 Then Exit Function

    Select Case lo_ValueType
    
        Case REG_SZ, REG_EXPAND_SZ
            
            'Construct the value
            ls_value = lo_Value & Chr(0)
            ll_Size = Len(ls_value)
            
            ll_Result = RegSetValueEx(ml_CurrentKeyHandle, ls_ValueName, 0&, lo_ValueType, ls_value, ll_Size)
    
            If ll_Result <> 0 Then Exit Function

        Case REG_MULTI_SZ
            'Construct the first value
            ls_value = lo_Value & Chr(0)
    
            If Not IsMissing(lo_MultiSZ_AdditionnalStrings) Then
                If IsArray(lo_MultiSZ_AdditionnalStrings) Then
                    
                    For Each ls_AdditionnalString In lo_MultiSZ_AdditionnalStrings
                        
                        If ls_AdditionnalString <> "" And ls_AdditionnalString <> Chr(0) And Not IsNull(ls_AdditionnalString) Then
                            ls_value = ls_value & ls_AdditionnalString & Chr(0)
                        End If
                    Next ls_AdditionnalString
                
                Else
    
                    'It's only one value
                    
                    If lo_MultiSZ_AdditionnalStrings <> "" And lo_MultiSZ_AdditionnalStrings <> Chr(0) And Not IsNull(lo_MultiSZ_AdditionnalStrings) Then
                        ls_value = ls_value & lo_MultiSZ_AdditionnalStrings & Chr(0)
                    End If
    
                End If
    
            End If
    
            ls_value = ls_value & Chr(0)
            ll_Size = Len(ls_value)
            
            ll_Result = RegSetValueEx(ml_CurrentKeyHandle, ls_ValueName, 0&, lo_ValueType, ls_value, ll_Size)
    
            If ll_Result <> 0 Then Exit Function

        Case REG_DWORD, REG_DWORD_LITTLE_ENDIAN
            ls_value = TranslateToString(CLng(lo_Value))
            ll_Size = 4 'Len(ls_value)
            
            ll_Result = RegSetValueEx(ml_CurrentKeyHandle, ls_ValueName, 0&, lo_ValueType, ls_value, ll_Size)
    
            If ll_Result <> 0 Then Exit Function
    
        Case Else
            
            Exit Function
    
    End Select
    
    CreateValue = True

    Exit Function
    
CreateValue_Err:

End Function

Public Function DeleteValue(ByVal ls_ValueName As String) As Boolean
'------------------------------------------------------------------
' Name : DeleteValue
'
' Purpose : Delete a value in the current key
'
' Parameters :
'       ls_ValueName        Name of the new value
'
' Return : True if the value was correctly deleted otherwise false
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim ll_Result As Long
    
    DeleteValue = False
    
    On Error GoTo DeleteValue_Err
    
    If ml_CurrentKeyHandle = 0 Then Exit Function
    
    ll_Result = RegDeleteValue(ml_CurrentKeyHandle, ls_ValueName)

    If ll_Result <> 0 Then Exit Function
    
    DeleteValue = True
    
    Exit Function
    
DeleteValue_Err:

End Function

Public Function GetValue(ByVal ls_ValueName As String, ByRef lo_Value As Variant, Optional lb_ReturnBinStr As Boolean = False) As Boolean
'------------------------------------------------------------------
' Name : GetValue
'
' Purpose : Return the required value in the current key
'
' Parameters :
'       ls_ValueName        Name of the new value
'       lo_Value            The value
'       lb_ReturnBinStr     The value must be return in binary mode
'                           False by default
'
' Return : True if the value was correctly returned otherwise false
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim ll_ValueSize As Long
Dim ls_value As String
Dim ll_Value As Long
Dim ls_TempValue As String
Dim lo_ValueType As lDataType
Dim ll_Result As Long
Dim ls_ReturnArray() As String
Dim i As Integer

    GetValue = False
    
    On Error GoTo GetValue_Err
    
    If ml_CurrentKeyHandle = 0 Then Exit Function
    
    'Read the size of the value
    ll_Result = RegQueryValueEx(ml_CurrentKeyHandle, ls_ValueName, 0&, lo_ValueType, ByVal 0&, ll_ValueSize)
    
    If ll_Result <> 0 Then Exit Function
    
    'declare the size of the value and read it
    ls_value = Space$(ll_ValueSize)
    
    ll_Result = RegQueryValueEx(ml_CurrentKeyHandle, ls_ValueName, 0&, lo_ValueType, ByVal ls_value, ll_ValueSize)
    
    Select Case lo_ValueType
        Case REG_NONE
            'Not defined
            Exit Function
    
        Case REG_SZ, REG_EXPAND_SZ
            'REG_SZ: A null-terminated String
            'REG_EXPAND_SZ : A null-terminated string that contains unexpanded references to
            '                environment variables (for example, "%PATH%").
            '                Use ExpandEnvironmentStrings to expand
            
            ls_value = Left$(ls_value, ll_ValueSize - 1)
            
            If lb_ReturnBinStr = True Then
                ls_TempValue = ""
        
                For i = 1 To Len(ls_value)
                    ls_TempValue = ls_TempValue & Right("00" & Trim(Hex(Asc(Mid(ls_value, i, 1)))), 2) & " "
                Next i
        
                ls_value = ls_TempValue
            
            End If
            
            lo_Value = ls_value
    
        Case REG_BINARY 'Binary data in any form.
            
            ls_value = Left$(ls_value, ll_ValueSize)

            If lb_ReturnBinStr = True Then
                ls_TempValue = ""
        
                For i = 1 To Len(ls_value)
                    ls_TempValue = ls_TempValue & Right("00" & Trim(Hex(Asc(Mid(ls_value, i, 1)))), 2) & " "
                Next i
        
                ls_value = ls_TempValue
            
            End If
            
            lo_Value = ls_value
            
        Case REG_DWORD, REG_DWORD_LITTLE_ENDIAN
            'A 32-bit number.
            
            ll_Value = TranslateToLong(ls_value)
                        
            If lb_ReturnBinStr = True Then
                ls_value = CStr(ll_Value)
                ls_TempValue = ""
                            
                For i = 1 To Len(ls_value)
                    ls_TempValue = ls_TempValue & Right("00" & Trim(Hex(Asc(Mid$(ls_value, i, 1)))), 2) & " "
                Next i
                
                lo_Value = ls_TempValue
                
            Else
            
                lo_Value = ll_Value
                
            End If
            
                
        Case REG_DWORD_BIG_ENDIAN
            'A 32-bit number in big-endian format.
            'In big-endian format, a multi-byte value is stored in memory from
            'the highest byte (the "big end") to the lowest byte. For example,
            'the value 0x12345678 is stored as (0x12 0x34 0x56 0x78) in big-endian
            'format.
                
            Exit Function
                
        Case REG_LINK
            'A Unicode symbolic link. Used internally; applications should not
            'use this type.
                   
            Exit Function
                
        Case REG_MULTI_SZ
            'Array of null-terminated string
                
            ls_value = Left(ls_value, ll_ValueSize)
                
            i = 0
                    
            While Len(ls_value) > 0
                ReDim Preserve ls_ReturnArray(i) As String
                
                'Affect the new string
                ls_ReturnArray(i) = Mid$(ls_value, 1, InStr(1, ls_value, Chr(0)) - 1)
                
                'Delete the affected string
                ls_value = Mid$(ls_value, InStr(1, ls_value, Chr(0)) + 1)
                i = i + 1
            Wend
                
            lo_Value = ls_ReturnArray
            
        Case REG_RESOURCE_LIST
            'Device driver resource list.
                
            Exit Function
                
        Case REG_FULL_RESOURCE_DESCRIPTOR
            'Device driver resource list.
                
            Exit Function
            
        Case REG_RESOURCE_REQUIREMENTS_LIST
            'Device driver resource list.
                            
            Exit Function
                    
        Case Else
            '????
            
            Exit Function
                
    End Select
    
    GetValue = True
   
    Exit Function
    
GetValue_Err:

End Function

Public Function GetAllSubKeys(lo_KeyList As Variant, Optional lb_FromRoot As Boolean = False) As Boolean
'------------------------------------------------------------------
' Name : GetAllSubKeys
'
' Purpose : Return an array of all sub keys
'
' Parameters :
'       lo_KeyList      Array of the sub keys
'       lb_FromRoot     True: List from the root
'                       False: List from the current key (default)
'
' Return : True if the list was correctly returned otherwise false
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim ll_Handle As Long
Dim li_Count As Integer
Dim li_size As Integer
Dim ls_SubKey As String
Dim ll_Result As Long
Dim ls_KeyList() As String

    Dim SubKey_Num As Integer
    Dim SubKey_Name As String
    Dim length As Long
    Dim ReturnArray() As Variant
    
    GetAllSubKeys = False

    On Error GoTo GetAllSubKeys_Err
    
    li_size = 256
    
    If lb_FromRoot = False Then
        If ml_CurrentKeyHandle = 0 Then Exit Function
        ll_Handle = ml_CurrentKeyHandle
    Else
        If ml_CurrentKeyHandle <> 0 Then CloseCurrentKey
        If ml_RootKey = 0 Then Exit Function
        ll_Handle = ml_RootKey
    End If
        
    'Get the Dir List
    li_Count = 0
        
    Do
        ls_SubKey = Space$(li_size)
    
        ll_Result = RegEnumKey(ll_Handle, li_Count, ls_SubKey, li_size)
        
        If ll_Result <> 0 Then Exit Do
    
        ls_SubKey = Left$(ls_SubKey, InStr(ls_SubKey, Chr$(0)) - 1)
    
        ReDim Preserve ls_KeyList(li_Count) As String
        
        ls_KeyList(li_Count) = ls_SubKey
    
        li_Count = li_Count + 1
    
    Loop
    
    GetAllSubKeys = True
    
    lo_KeyList = ls_KeyList
    
    Exit Function

GetAllSubKeys_Err:

End Function

Public Function GetAllValues(lo_ValueNameList As Variant) As Boolean
'------------------------------------------------------------------
' Name : GetAllValues
'
' Purpose : Return an array of all values (name only)
'
' Parameters :
'       lo_ValueNameList    Array of the values (name only)
'
' Return : True if the list was correctly returned otherwise false
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim li_Count As Integer
Dim ls_ValueName As String
Dim ll_SizeName As Long
Dim ls_value As String
Dim ll_SizeValue As Long
Dim ll_Result As Long
Dim ll_KeyType As Long
Dim ls_ValueNameList() As String

    GetAllValues = False
    
    On Error GoTo GetAllValues_Err
    
    If ml_CurrentKeyHandle = 0 Then Exit Function
    
    'Get the Values List
    li_Count = 0

    Do
        ll_SizeName = 254
        ll_SizeValue = 254
    
        ls_ValueName = String(ll_SizeName + 1, " ")
        ls_value = String(ll_SizeValue + 1, " ")

        ll_Result = RegEnumValue(ByVal ml_CurrentKeyHandle, ByVal li_Count, ls_ValueName, ll_SizeName, 0, ll_KeyType, ls_value, ll_SizeValue)
        If ll_Result <> 0 Then Exit Do

        ls_ValueName = Left(ls_ValueName, InStr(ls_ValueName, Chr$(0)) - 1)
        
        ReDim Preserve ls_ValueNameList(li_Count) As String
        
        ls_ValueNameList(li_Count) = ls_ValueName
        li_Count = li_Count + 1
    Loop

    lo_ValueNameList = ls_ValueNameList
    
    GetAllValues = True
    
    Exit Function
    
GetAllValues_Err:

End Function

Private Function AddSubKeyString(ls_SubKey, ls_SubKeyToAdd) As String
'------------------------------------------------------------------
' Name : AddSubKeyString (Private)
'
' Purpose : Add a sub key to the current key
'
' Parameters :
'       ls_subKey       The key
'       ls_SubKeyToAdd  The sub key to add
'
' Return : The new key
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
   
    AddSubKeyString = ""
    
    On Error GoTo AddSubKeyString_Err
    
    'Construct the new sub key
    If Right(ls_SubKey, 1) <> "\" And Left(ls_SubKeyToAdd, 1) <> "\" Then
        If ls_SubKey <> "" Then
            AddSubKeyString = ls_SubKey & "\" & ls_SubKeyToAdd
        Else
            AddSubKeyString = ls_SubKeyToAdd
        End If
    Else
        If Right(ls_SubKey, 1) <> "\" Or Left(ls_SubKeyToAdd, 1) <> "\" Then
            AddSubKeyString = ls_SubKey & ls_SubKeyToAdd
        Else
            AddSubKeyString = Left(ls_SubKey, Len(ls_SubKey) - 1) & ls_SubKeyToAdd
        End If
    End If
    
    Exit Function

AddSubKeyString_Err:
    
End Function

Public Function BackOneSubKey() As Boolean
'------------------------------------------------------------------
' Name : BackOneSubKey
'
' Purpose : Return to the parent key
'
' Parameters : None
'
' Return : True if the parent key was correctly opened otherwise false
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim ls_OldSubKey As String
Dim li_Position As Integer
    
    BackOneSubKey = False
    
    On Error GoTo BackOneSubKey_Err
    
    If ml_CurrentKeyHandle = 0 Then Exit Function
    
    ls_OldSubKey = ms_SubKey

    CloseCurrentKey

    li_Position = FindLastBackSlash(ls_OldSubKey) - 1
    
    If li_Position > 0 Then
        ls_OldSubKey = Mid$(ls_OldSubKey, 1, li_Position)
    Else
        Exit Function
    End If

    BackOneSubKey = OpenSubKey(ls_OldSubKey, True)
    
    Exit Function
    
BackOneSubKey_Err:
    
End Function

Private Function FindLastBackSlash(ls_string As String) As Integer
'------------------------------------------------------------------
' Name : FindLastBackSlash (Private)
'
' Purpose : Find the last BackShlash of a string
'
' Parameters :
'       ls_string       the string to analyse
'
' Return : The position of the last backshlash
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim i As Integer

    FindLastBackSlash = 0

    For i = Len(ls_string) To 1 Step -1
        
        If Mid$(ls_string, i, 1) = "\" Then
            FindLastBackSlash = i
            Exit Function
        End If

    Next i

End Function

Private Function TranslateToString(ByVal ll_Value As Long) As String
'------------------------------------------------------------------
' Name : TranslateToString (Private)
'
' Purpose : Translate a long to a string
'
' Parameters :
'       ll_value       the value to translate
'
' Return : The string containing the value
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim i As Integer
Dim ls_value As String
Dim li_Count As Integer

    ls_value = ""
    While ll_Value <> 0
        i = (ll_Value / 256 - Fix(ll_Value / 256)) * 256
        ls_value = ls_value & Chr(i)
        ll_Value = Fix(ll_Value - i) / 256
    Wend

    TranslateToString = ls_value

End Function

Private Function TranslateToLong(ByVal ls_value As String) As Long
'------------------------------------------------------------------
' Name : TranslateToLong (Private)
'
' Purpose : Translate a string to a long
'
' Parameters :
'       ls_value       the string to translate
'
' Return : The value
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
Dim i As Integer
Dim ll_Value As Long
Dim li_Count As Integer

    ll_Value = 0
    For i = Len(ls_value) To 1 Step -1
        ll_Value = ll_Value * 256 + Asc(Mid(ls_value, i, 1))
    Next
    
    TranslateToLong = ll_Value

End Function

Private Sub Class_Initialize()
'------------------------------------------------------------------
' Name : Class_Initialize (Private)
'
' Purpose : Initialize the class
'
' Parameters : None
'
' Return : None
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    ml_RootKey = 0
    ms_SubKey = ""
    ml_CurrentKeyHandle = 0
End Sub

Private Sub Class_Terminate()
'------------------------------------------------------------------
' Name : Class_Terminate (Private)
'
' Purpose : Terminate the class
'
' Parameters : None
'
' Return : None
'
' review : 15/02/2000 by AD
'------------------------------------------------------------------
    If ml_CurrentKeyHandle <> 0 Then
        CloseCurrentKey
    End If
End Sub
